/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.webservices;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.VWString;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.integrator.adaptors.webservices.AxisCall;
import filenet.vw.integrator.adaptors.webservices.WSRequestOperation;
import filenet.ws.api.WSBindingOperation;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSMessage;
import filenet.ws.api.WSPort;
import filenet.ws.listener.axis.rm.WSRMSequenceInfo;
import filenet.ws.utils.P8BPMSoapActionURI;
import filenet.ws.utils.WSEncString;
import filenet.ws.utils.att.IWSAttLoader;
import filenet.ws.utils.att.IWSAttSession;
import java.net.ConnectException;
import org.apache.sandesha.util.PolicyLoader;
import org.w3c.dom.Node;

public class WSReplyOperation
extends WSRequestOperation {
    protected static final String m_className = "WSReplyOperation";
    private static boolean done = false;

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 00:52:38  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.38  $";
    }

    public WSReplyOperation(VWSession PESession, IWSAttSession WSAttSession, int wsTimeout, boolean traceIt, String traceFile, long traceFileSize, long cacheTimeout, boolean validateMessage, int tIndex) {
        super(PESession, WSAttSession, wsTimeout, traceIt, traceFile, traceFileSize, cacheTimeout, validateMessage, tIndex);
        this.m_wsLogger.setType("WS-Request[" + tIndex + "] reply");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String reply(VWStepElement se) throws VWException {
        String resStatus = "OK";
        boolean bReplyForRM = false;
        boolean bSyncReply = false;
        boolean sendAsRM = false;
        String wobNum = null;
        String m_method = "reply:" + se.getWorkClassName();
        if (se == null) {
            throw new VWException("ws.WSOperations.nullStepElement", "Step element is null");
        }
        try {
            logger.entering(m_className, m_method);
            String soapAction = null;
            String soapAddress = null;
            String replyHeader = null;
            String wfNum = se.getWorkflowNumber();
            wobNum = se.getWorkObjectNumber();
            String m_endPointRef = (String)se.getParameterValue("MyEndPointRef");
            if (m_endPointRef != null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "MyEndPointRef=" + m_endPointRef);
                }
                VWXMLWrapper endpointRef_doc = new VWXMLWrapper(m_endPointRef);
                this.m_endPoint = VWXMLWrapper.getNodeValue(endpointRef_doc.getRootNode(), "Address");
                Node refPropsNode = VWXMLWrapper.getNodeNamed(endpointRef_doc.getRootNode(), "ReferenceProperties");
                Node nReplyHeader = VWXMLWrapper.getNodeNamed(refPropsNode, "ReplyHeader");
                Node nReplyTo = VWXMLWrapper.getNodeNamed(nReplyHeader, "ReplyTo");
                soapAddress = VWXMLWrapper.getNodeValue(nReplyTo, "Address");
                Node nReplyToRefProps = VWXMLWrapper.getNodeNamed(nReplyTo, "ReferenceProperties");
                soapAction = VWXMLWrapper.getNodeValue(nReplyToRefProps, "ReplySOAPAction");
                replyHeader = endpointRef_doc.toXML(nReplyHeader);
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "soapAddress=" + soapAddress + ", soapAction=" + soapAction + ", replyHeader=" + replyHeader);
                }
            }
            this.m_portType = (String)se.getParameterValue("PortType");
            this.m_op = (String)se.getParameterValue("Op");
            this.m_inputMsg = (String)se.getParameterValue("Message");
            this.m_fault = (String)se.getParameterValue("FaultName");
            try {
                this.m_inputMsgName = (String)se.getParameterValue("InputMsgName");
                this.m_outputMsgName = (String)se.getParameterValue("OutputMsgName");
            }
            catch (Throwable t) {
                logger.throwing(m_className, m_method, t);
            }
            this.traceData();
            WSReplyOperation.checkRequiredParameters(this.m_endPoint, "WsdlEndPoint");
            WSReplyOperation.checkRequiredParameters(this.m_portType, "PortType");
            WSReplyOperation.checkRequiredParameters(this.m_op, "Op");
            WSReplyOperation.checkRequiredParameters(soapAddress, "SOAP Address");
            WSReplyOperation.checkRequiredParameters(soapAction, "SOAP Action");
            if (this.m_inputMsg == null && this.m_fault == null) {
                VWException vwex = new VWException("ws.WSOperations.missingInputMsgOrFault", "No Message nor Fault was specified for Reply.");
                logger.throwing(m_className, m_method, vwex);
                throw vwex;
            }
            this.m_wsLogger.append("EndPoint=").append(this.m_endPoint).eoln();
            this.m_wsLogger.append("PortType=").append(this.m_portType).eoln();
            this.m_wsLogger.append("Operation=").append(this.m_op).eoln();
            this.m_wsLogger.append("InputMsgName=").append(this.m_inputMsgName).eoln();
            this.m_wsLogger.append("OutputMsgName=").append(this.m_outputMsgName).eoln();
            this.m_wsLogger.append("WorkflowName=").append(se.getWorkflowName()).eoln();
            this.m_wsLogger.append("WorkflowNumber=").append(wfNum).eoln();
            this.m_wsLogger.append("WorkObjectNumber=").append(wobNum).eoln();
            this.m_wsLogger.append("Initial InputMsg=").append(this.m_inputMsg).eoln();
            Object value = se.getParameterValue("ReliableFlag");
            if (value != null && value instanceof Boolean) {
                bReplyForRM = (Boolean)value;
            }
            WSDefinition m_definition = null;
            try {
                long inactivityTimeOut = 600000L;
                long baseRetryInterval = 3000L;
                if (bReplyForRM) {
                    inactivityTimeOut = PolicyLoader.getInstance().getInactivityTimeout();
                    baseRetryInterval = PolicyLoader.getInstance().getBaseRetransmissionInterval();
                }
                m_definition = this.getWSDLDefinition(this.m_endPoint, baseRetryInterval, inactivityTimeOut);
            }
            catch (Exception ex) {
                logger.throwing(m_className, m_method, ex);
                throw ex;
            }
            WSPort m_port = m_definition.getDefaultPort(this.m_portType);
            WSBindingOperation SOAPOp = m_port.getBindingOperation(this.m_op, this.m_inputMsgName, this.m_outputMsgName);
            if (SOAPOp == null) {
                VWException vwex = new VWException("ws.WSOperations.noSOAPOp", "Cannot find binding operation for op={0}, port={1}, service={2}.", this.m_op, this.m_portType, this.m_endPoint);
                logger.throwing(m_className, m_method, vwex);
                throw vwex;
            }
            this.getNameSpaces(m_definition);
            boolean isDocument = true;
            this.checkInlineAttachments();
            this.m_inputMsg = WSEncString.Decode(this.m_inputMsg, wfNum);
            WSMessage SOAPMsg = m_definition.getOperation(this.m_portType, this.m_op, this.m_inputMsgName, this.m_outputMsgName).getOutMessage();
            WSRequestOperation.MIMEHandler mimeHandler = new WSRequestOperation.MIMEHandler(this, SOAPMsg, SOAPOp, false);
            IWSAttLoader[] docs = mimeHandler.getDocs();
            Integer v = (Integer)se.getParameterValue("Status");
            if (v != null) {
                this.m_validateMessages = (v & 0x80) > 0;
            }
            boolean bl = this.m_validateMessages = this.m_validateMessages && docs == null && !mimeHandler.hasMIME() && m_definition.getValidateUsingSchema();
            if (this.m_validateMessages && (this.m_fault == null || this.m_fault.length() == 0)) {
                this.validateMessage(m_definition);
            }
            P8BPMSoapActionURI soapActionURI = new P8BPMSoapActionURI(soapAction);
            bSyncReply = soapActionURI.isSync();
            if (bReplyForRM) {
                if (bSyncReply) {
                    soapActionURI.setRM(wobNum);
                    sendAsRM = false;
                    soapAction = soapActionURI.toStringEx();
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Reply soapActionURI = " + soapAction);
                    }
                } else {
                    sendAsRM = true;
                }
            }
            int rmReplyFlag = 0;
            if (sendAsRM) {
                rmReplyFlag = 4;
            }
            new AxisCall().invokeSOAPViaSAAJ(this, soapAction, soapAddress, null, replyHeader, true, false, rmReplyFlag, wobNum, null, docs);
        }
        catch (Throwable t) {
            logger.throwing(m_className, m_method, t);
            StringBuffer errbuf = new StringBuffer();
            errbuf.append(VWException.DescribeThrowableAndItsCause(t));
            if (errbuf.length() > 256) {
                errbuf.setLength(253);
                errbuf.append("...");
            }
            this.m_fault = errbuf.toString();
            this.m_outputMsg = WSRequestOperation.getClientName() + errbuf.toString();
            if (sendAsRM && wobNum != null) {
                String rmExtraDetails = null;
                WSRMSequenceInfo seqInfo = WSRMSequenceInfo.getSequenceInfoByWobnum(wobNum);
                if (seqInfo != null) {
                    rmExtraDetails = seqInfo.getSeqStatusMsg();
                }
                if (rmExtraDetails != null) {
                    this.m_outputMsg = this.m_outputMsg + "\n" + rmExtraDetails;
                }
            }
            this.m_status = t instanceof ConnectException ? 2 : 3;
            this.m_wsLogger.append("Fault=").append(this.m_fault).eoln();
            this.m_wsLogger.append("Real Exception Message=").append(this.m_outputMsg).eoln();
        }
        finally {
            if (this.m_status == -1) {
                this.m_status = 0;
            } else {
                se.setParameterValue("Exception", this.m_fault, true);
            }
            se.setParameterValue("Status", new Integer(this.m_status), true);
            this.m_wsLogger.println(null);
        }
        try {
            if (bReplyForRM && bSyncReply) {
                this.m_status = 1;
                se.setParameterValue("Status", new Integer(this.m_status), true);
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Calling doSave(true)");
                }
                se.doSave(true);
            } else {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Calling doDispatch");
                }
                se.doDispatch();
            }
        }
        catch (VWException tD) {
            logger.throwing(m_className, m_method, tD);
            String s = new VWString("filenet.vw.integrator.adaptors.webservices.WSInvoke.DoDispatchFailed", "Unable to dispatch the step element {0}, exception={1}").toString(wobNum, VWException.DescribeThrowableAndItsCause(tD));
            logger.warning(m_className, m_method, s);
            throw tD;
        }
        logger.exiting(m_className, m_method);
        return resStatus;
    }
}

